import { Component, inject } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { CarouselModule, OwlOptions } from 'ngx-owl-carousel-o';
import { Observable } from 'rxjs';

import { environment } from '../../../../environments/environment';
import { GetBlogsAction } from '../../../shared/action/blog.action';
import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import * as data from '../../../shared/data/owl-carousel';
import { IBlog, IBlogModel } from '../../../shared/interface/blog.interface';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { IAboutUs, IOption } from '../../../shared/interface/theme-option.interface';
import { BlogState } from '../../../shared/state/blog.state';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';

export interface IClients {
  title: string;
  count: string;
  imageIcon: string;
  description: string;
}

@Component({
  selector: 'app-about-us',
  imports: [TranslateModule, RouterModule, CarouselModule, Breadcrumb, NoData],
  templateUrl: './about-us.html',
  styleUrl: './about-us.scss',
})
export class AboutUs {
  private store = inject(Store);

  blog$: Observable<IBlogModel> = inject(Store).select(BlogState.blog) as Observable<IBlogModel>;
  themeOptions$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public aboutUs?: IAboutUs;
  public blogs: IBlog[] = [];

  public breadcrumb: IBreadcrumb = {
    title: 'About Us',
    items: [{ label: 'About Us', active: true }],
  };

  public productSlider = data.productSliderMargin;
  public storageURL = environment.storageURL;

  public clientsOptions: OwlOptions = {
    loop: true,
    margin: 20,
    items: 3,
    autoplay: true,
    nav: false,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 2,
      },
      740: {
        items: 3,
      },
      940: {
        items: 4,
      },
    },
  };

  public teamOptions: OwlOptions = {
    loop: true,
    margin: 20,
    items: 4,
    autoplay: true,
    nav: false,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 2,
      },
      740: {
        items: 3,
      },
      940: {
        items: 4,
      },
    },
  };

  public testimonialsOptions: OwlOptions = {
    loop: true,
    margin: 20,
    items: 4,
    // autoplay:true,
    center: true,
    nav: false,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 2,
      },
      740: {
        items: 3,
      },
      940: {
        items: 4,
      },
    },
  };

  public blogOptions: OwlOptions = {
    loop: true,
    margin: 20,
    items: 4,
    autoplay: true,
    nav: false,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 2,
      },
      740: {
        items: 4,
      },
      940: {
        items: 4,
      },
    },
  };

  constructor() {
    this.themeOptions$.subscribe(option => {
      this.aboutUs = option?.about_us;
    });
    if (Array.isArray(this.aboutUs?.blog?.blog_ids) && this.aboutUs?.blog?.blog_ids?.length) {
      this.store.dispatch(
        new GetBlogsAction({ status: 1, ids: this.aboutUs?.blog.blog_ids?.join() }),
      );
      this.blog$.subscribe(blogs => {
        this.blogs = blogs?.data.filter(blog => this.aboutUs?.blog.blog_ids?.includes(blog?.id!));
      });
    }
  }
}
