import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetFaqsAction } from '../../../shared/action/page.action';
import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { IFaqModel } from '../../../shared/interface/page.interface';
import { PageService } from '../../../shared/services/page.service';
import { PageState } from '../../../shared/state/page.state';
import { SkeletonPage } from '../skeleton-page/skeleton-page';

@Component({
  selector: 'app-faq',
  imports: [CommonModule, TranslateModule, NgbModule, Breadcrumb, SkeletonPage, NoData],
  templateUrl: './faq.html',
  styleUrl: './faq.scss',
})
export class Faq {
  public pageService = inject(PageService);
  private store = inject(Store);

  public breadcrumb: IBreadcrumb = {
    title: "FAQ's",
    items: [{ label: "FAQ's", active: true }],
  };

  faq$: Observable<IFaqModel> = inject(Store).select(PageState.faq);

  constructor() {
    this.pageService.skeletonLoader = true;
    this.store.dispatch(new GetFaqsAction()).subscribe({
      complete: () => {
        this.pageService.skeletonLoader = false;
      },
    });
  }
}
