import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetCouponsAction } from '../../../shared/action/coupon.action';
import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { ICouponModel } from '../../../shared/interface/coupon.interface';
import { CouponState } from '../../../shared/state/coupon.state';
import { CouponService } from './../../../shared/services/coupon.service';

@Component({
  selector: 'app-offer',
  imports: [CommonModule, TranslateModule, Breadcrumb, NoData],
  templateUrl: './offer.html',
  styleUrl: './offer.scss',
})
export class Offer {
  public couponService = inject(CouponService);
  private store = inject(Store);

  public skeletonItems = Array.from({ length: 8 }, (_, index) => index);
  public breadcrumb: IBreadcrumb = {
    title: 'Offer',
    items: [{ label: 'Offer', active: true }],
  };

  coupon$: Observable<ICouponModel> = inject(Store).select(CouponState.coupon);

  constructor() {
    this.store.dispatch(new GetCouponsAction({ status: 1 }));
  }

  copyFunction(txt: string) {
    void navigator.clipboard.writeText(txt);
  }
}
