import { Routes } from '@angular/router';

import { PageResolver } from '../../shared/resolvers/page.resolver';

export const pageRoutes: Routes = [
  {
    path: 'page/:slug',
    loadComponent: () => import('./page').then(m => m.Page),
    resolve: {
      data: PageResolver,
    },
  },
  {
    path: 'faq',
    loadComponent: () => import('./faq/faq').then(m => m.Faq),
  },
  {
    path: '404',
    loadComponent: () => import('./error404/error404').then(m => m.Error404),
  },
  {
    path: 'contact-us',
    loadComponent: () => import('./contact-us/contact-us').then(m => m.ContactUs),
  },
  {
    path: 'offers',
    loadComponent: () => import('./offer/offer').then(m => m.Offer),
  },
  {
    path: 'about-us',
    loadComponent: () => import('./about-us/about-us').then(m => m.AboutUs),
  },
  {
    path: 'search',
    loadComponent: () => import('./search/search').then(m => m.Search),
  },
];
