import { CommonModule } from '@angular/common';
import { Component, Input, output } from '@angular/core';

import { IValues } from '../../../../shared/interface/setting.interface';

@Component({
  selector: 'app-payment-block',
  imports: [CommonModule],
  templateUrl: './payment-block.html',
  styleUrl: './payment-block.scss',
})
export class PaymentBlock {
  @Input() setting: IValues;

  readonly selectPaymentMethod = output<string>();

  ngOnInit() {
    // Automatically emit the selectAddress event for the first item if it's available
    if (this.setting && this.setting?.payment_methods?.length! > 0) {
      if (this.setting?.payment_methods?.[0].status) {
        this.selectPaymentMethod.emit(this.setting?.payment_methods?.[0].name);
      }
    }
  }

  set(value: string) {
    this.selectPaymentMethod.emit(value);
  }
}
