import { Component, inject, input } from '@angular/core';

import * as data from '../../../../shared/data/owl-carousel';
import { Params } from '../../../../shared/interface/core.interface';
import { AttributeService } from '../../../../shared/services/attribute.service';
import { CollectionCategories } from '../widgets/collection-categories/collection-categories';
import { CollectionProducts } from '../widgets/collection-products/collection-products';

@Component({
  selector: 'app-collection-category-sidebar',
  imports: [CollectionCategories, CollectionProducts],
  templateUrl: './collection-category-sidebar.html',
  styleUrl: './collection-category-sidebar.scss',
})
export class CollectionCategorySidebar {
  public attributeService = inject(AttributeService);

  readonly filter = input<Params>();

  public categorySlider = data.categorySlider;
}
