import { Component, inject, input } from '@angular/core';

import * as data from '../../../../shared/data/owl-carousel';
import { Params } from '../../../../shared/interface/core.interface';
import { AttributeService } from '../../../../shared/services/attribute.service';
import { CollectionCategories } from '../widgets/collection-categories/collection-categories';
import { CollectionProducts } from '../widgets/collection-products/collection-products';
import { Sidebar } from '../widgets/sidebar/sidebar';

@Component({
  selector: 'app-collection-category-slider',
  imports: [CollectionCategories, Sidebar, CollectionProducts],
  templateUrl: './collection-category-slider.html',
  styleUrl: './collection-category-slider.scss',
})
export class CollectionCategorySlider {
  public attributeService = inject(AttributeService);

  readonly filter = input<Params>();

  public categorySlider = data.categorySlider;
}
