import { Component, inject, input } from '@angular/core';

import { Params } from '../../../../shared/interface/core.interface';
import { AttributeService } from '../../../../shared/services/attribute.service';
import { CollectionProducts } from '../widgets/collection-products/collection-products';
import { Sidebar } from '../widgets/sidebar/sidebar';

@Component({
  selector: 'app-collection-offcanvas-filter',
  imports: [Sidebar, CollectionProducts],
  templateUrl: './collection-offcanvas-filter.html',
  styleUrl: './collection-offcanvas-filter.scss',
})
export class CollectionOffcanvasFilter {
  public attributeService = inject(AttributeService);

  readonly filter = input<Params>();

  closeCanvasMenu() {
    this.attributeService.offCanvasMenu = false;
  }
}
