import { Component, inject } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { CollectionBanner } from './collection-banner/collection-banner';
import { CollectionCategorySidebar } from './collection-category-sidebar/collection-category-sidebar';
import { CollectionCategorySlider } from './collection-category-slider/collection-category-slider';
import { CollectionLeftSidebar } from './collection-left-sidebar/collection-left-sidebar';
import { CollectionList } from './collection-list/collection-list';
import { CollectionNoSidebar } from './collection-no-sidebar/collection-no-sidebar';
import { CollectionOffcanvasFilter } from './collection-offcanvas-filter/collection-offcanvas-filter';
import { CollectionRightSidebar } from './collection-right-sidebar/collection-right-sidebar';
import { GetProductsAction } from '../../../shared/action/product.action';
import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { Params } from '../../../shared/interface/core.interface';
import { IProductModel } from '../../../shared/interface/product.interface';
import { IOption } from '../../../shared/interface/theme-option.interface';
import { ProductState } from '../../../shared/state/product.state';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';

@Component({
  selector: 'app-collection',
  imports: [
    Breadcrumb,
    CollectionCategorySlider,
    CollectionCategorySidebar,
    CollectionBanner,
    CollectionLeftSidebar,
    CollectionRightSidebar,
    CollectionList,
    CollectionOffcanvasFilter,
    CollectionNoSidebar,
  ],
  templateUrl: './collection.html',
  styleUrl: './collection.scss',
})
export class Collection {
  private route = inject(ActivatedRoute);
  private store = inject(Store);

  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);
  themeOptions$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public breadcrumb: IBreadcrumb = {
    title: 'Collections',
    items: [{ label: 'Collections', active: false }],
  };
  public layout: string = 'collection_category_slider';
  public skeleton: boolean = true;

  public filter: Params = {
    page: 1, // Current page number
    paginate: 40, // Display per page,
    status: 1,
    field: 'created_at',
    price: '',
    category: '',
    tag: '',
    sort: 'asc', // ASC, DSC
    sortBy: 'asc',
    rating: '',
    attribute: '',
  };

  public totalItems: number = 0;

  constructor() {
    // Get Query params..
    this.route.queryParams.subscribe(params => {
      this.filter = {
        page: params['page'] ? params['page'] : 1,
        paginate: 40,
        status: 1,
        price: params['price'] ? params['price'] : '',
        brand: params['brand'] ? params['brand'] : '',
        category: params['category'] ? params['category'] : '',
        tag: params['tag'] ? params['tag'] : '',
        field: params['field'] ? params['field'] : this.filter['field'],
        sortBy: params['sortBy'] ? params['sortBy'] : this.filter['sortBy'],
        rating: params['rating'] ? params['rating'] : '',
        attribute: params['attribute'] ? params['attribute'] : '',
      };

      this.store.dispatch(new GetProductsAction(this.filter));

      // Params For Demo Purpose only
      if (params['layout']) {
        this.layout = params['layout'];
      } else {
        // Get Collection Layout
        this.themeOptions$.subscribe(option => {
          this.layout =
            option?.collection && option?.collection?.collection_layout
              ? option?.collection?.collection_layout
              : 'collection_category_slider';
        });
      }

      this.filter['layout'] = this.layout;
    });
    this.product$.subscribe(product => (this.totalItems = product?.total));
  }
}
