import { CommonModule } from '@angular/common';
import { Component, inject, input } from '@angular/core';

import { Store } from '@ngxs/store';
import { OwlOptions } from 'ngx-owl-carousel-o';
import { Observable } from 'rxjs';

import { Categories } from '../../../../../shared/components/widgets/categories/categories';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';

@Component({
  selector: 'app-collection-categories',
  imports: [CommonModule, Categories],
  templateUrl: './collection-categories.html',
  styleUrl: './collection-categories.scss',
})
export class CollectionCategories {
  readonly style = input<string>('vertical');
  readonly image = input<string>();
  readonly theme = input<string>();
  readonly title = input<string>();
  readonly sliderOption = input<OwlOptions>();

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;
}
