import { CommonModule } from '@angular/common';
import { Component, inject, input } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { Pagination } from '../../../../../shared/components/widgets/pagination/pagination';
import { Params } from '../../../../../shared/interface/core.interface';
import { IProductModel } from '../../../../../shared/interface/product.interface';
import { ProductState } from '../../../../../shared/state/product.state';

@Component({
  selector: 'app-collection-paginate',
  imports: [CommonModule, Pagination],
  templateUrl: './collection-paginate.html',
  styleUrl: './collection-paginate.scss',
})
export class CollectionPaginate {
  public route = inject(ActivatedRoute);
  public router = inject(Router);

  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);

  readonly filter = input<Params>();

  public totalItems: number = 0;

  constructor() {
    this.product$.subscribe(product => (this.totalItems = product?.total));
  }

  setPaginate(page: number) {
    void this.router.navigate([], {
      relativeTo: this.route,
      queryParams: {
        page: page,
      },
      queryParamsHandling: 'merge', // preserve the existing query params in the route
    });
  }
}
