import { CommonModule } from '@angular/common';
import { Component, inject, input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { NoData } from '../../../../../shared/components/widgets/no-data/no-data';
import { ProductBox } from '../../../../../shared/components/widgets/product-box/product-box';
import { SkeletonProductBox } from '../../../../../shared/components/widgets/product-box/widgets/skeleton-product-box/skeleton-product-box';
import { Params } from '../../../../../shared/interface/core.interface';
import { IProductModel } from '../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ProductService } from '../../../../../shared/services/product.service';
import { ProductState } from '../../../../../shared/state/product.state';
import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';
import { CollectionPaginate } from '../collection-paginate/collection-paginate';
import { CollectionSort } from '../collection-sort/collection-sort';

@Component({
  selector: 'app-collection-products',
  imports: [
    CommonModule,
    CollectionSort,
    SkeletonProductBox,
    ProductBox,
    NoData,
    CollectionPaginate,
  ],
  templateUrl: './collection-products.html',
  styleUrl: './collection-products.scss',
})
export class CollectionProducts {
  public productService = inject(ProductService);

  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);
  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  readonly filter = input<Params>();
  readonly gridCol = input<string>();

  public gridClass: string =
    'row g-sm-4 g-3 row-cols-xl-4 row-cols-md-3 row-cols-2 product-list-section';

  public skeletonItems = Array.from({ length: 40 }, (_, index) => index);

  setGridClass(gridClass: string) {
    this.gridClass = gridClass;
  }
}
