import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetAttributesAction } from '../../../../../shared/action/attribute.action';
import { GetBrandsAction } from '../../../../../shared/action/brand.action';
import { IAttributeModel } from '../../../../../shared/interface/attribute.interface';
import { IBrandModel } from '../../../../../shared/interface/brand.interface';
import { Params } from '../../../../../shared/interface/core.interface';
import { AttributeService } from '../../../../../shared/services/attribute.service';
import { AttributeState } from '../../../../../shared/state/attribute.state';
import { BrandState } from '../../../../../shared/state/brand.state';
import { CollectionAttributesFilter } from '../filter/collection-attributes-filter/collection-attributes-filter';
import { CollectionBrandFilter } from '../filter/collection-brand-filter/collection-brand-filter';
import { CollectionCategoryFilter } from '../filter/collection-category-filter/collection-category-filter';
import { CollectionFilter } from '../filter/collection-filter/collection-filter';
import { CollectionPriceFilter } from '../filter/collection-price-filter/collection-price-filter';
import { CollectionRatingFilter } from '../filter/collection-rating-filter/collection-rating-filter';
import { SkeletonCollectionSidebar } from '../skeleton-collection-sidebar/skeleton-collection-sidebar';

@Component({
  selector: 'app-collection-sidebar',
  imports: [
    TranslateModule,
    NgbModule,
    CommonModule,
    CollectionFilter,
    SkeletonCollectionSidebar,
    CollectionCategoryFilter,
    CollectionBrandFilter,
    CollectionAttributesFilter,
    CollectionPriceFilter,
    CollectionRatingFilter,
  ],
  templateUrl: './sidebar.html',
  styleUrl: './sidebar.scss',
})
export class Sidebar {
  private store = inject(Store);
  public attributeService = inject(AttributeService);

  @Input() filter: Params;
  readonly hideFilter = input<string[]>();

  attribute$: Observable<IAttributeModel> = inject(Store).select(AttributeState.attribute);
  brand$: Observable<IBrandModel> = inject(Store).select(BrandState.brand);

  constructor() {
    this.store.dispatch(new GetAttributesAction({ status: 1 }));
    this.store.dispatch(new GetBrandsAction({ status: 1 }));
  }

  closeCanvasMenu() {
    this.attributeService.offCanvasMenu = false;
  }
}
