import { Component, Input, input, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';

import { IProduct } from '../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { PaymentOption } from '../widgets/payment-option/payment-option';
import { ProductAction } from '../widgets/product-action/product-action';
import { ProductBundle } from '../widgets/product-bundle/product-bundle';
import { ProductContain } from '../widgets/product-contain/product-contain';
import { ProductDeliveryInformation } from '../widgets/product-delivery-information/product-delivery-information';
import { ProductDetailsTabs } from '../widgets/product-details-tabs/product-details-tabs';
import { ProductInformation } from '../widgets/product-information/product-information';
import { ProductSocialShare } from '../widgets/product-social-share/product-social-share';
import { VideoPlayModal } from '../widgets/video-play-modal/video-play-modal';

@Component({
  selector: 'app-product-images',
  imports: [
    TranslateModule,
    ProductContain,
    ProductAction,
    ProductInformation,
    ProductDeliveryInformation,
    PaymentOption,
    ProductSocialShare,
    ProductBundle,
    ProductDetailsTabs,
    VideoPlayModal,
  ],
  templateUrl: './product-images.html',
  styleUrl: './product-images.scss',
})
export class ProductImages {
  @Input() product: IProduct;
  readonly option = input<IOption | null>();

  readonly VideoPlayModal = viewChild<VideoPlayModal>('videoPlayModal');

  public videType = ['video/mp4', 'video/webm', 'video/ogg'];
  public audioType = ['audio/mpeg', 'audio/wav', 'audio/ogg'];
}
