import { Component, Input, input, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { CarouselModule } from 'ngx-owl-carousel-o';

import * as data from '../../../../../shared/data/owl-carousel';
import { IProduct } from '../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ProductSidebar } from '../sidebar/sidebar';
import { PaymentOption } from '../widgets/payment-option/payment-option';
import { ProductAction } from '../widgets/product-action/product-action';
import { ProductBundle } from '../widgets/product-bundle/product-bundle';
import { ProductContain } from '../widgets/product-contain/product-contain';
import { ProductDeliveryInformation } from '../widgets/product-delivery-information/product-delivery-information';
import { ProductDetailsTabs } from '../widgets/product-details-tabs/product-details-tabs';
import { ProductInformation } from '../widgets/product-information/product-information';
import { ProductSocialShare } from '../widgets/product-social-share/product-social-share';
import { VideoPlayModal } from '../widgets/video-play-modal/video-play-modal';

@Component({
  selector: 'app-product-slider',
  imports: [
    TranslateModule,
    CarouselModule,
    ProductContain,
    ProductAction,
    ProductInformation,
    ProductDeliveryInformation,
    PaymentOption,
    ProductSocialShare,
    ProductBundle,
    ProductDetailsTabs,
    ProductSidebar,
    VideoPlayModal,
  ],
  templateUrl: './product-slider.html',
  styleUrl: './product-slider.scss',
})
export class ProductSlider {
  @Input() product: IProduct;
  readonly option = input<IOption | null>();

  readonly VideoPlayModal = viewChild<VideoPlayModal>('videoPlayModal');

  public productSliderLayout = data.productSliderLayout;
  public videType = ['video/mp4', 'video/webm', 'video/ogg'];
  public audioType = ['audio/mpeg', 'audio/wav', 'audio/ogg'];
}
