import { Component, Input, input, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { NgxImageZoomModule } from 'ngx-image-zoom';
import { CarouselModule } from 'ngx-owl-carousel-o';

import * as data from '../../../../../shared/data/owl-carousel';
import { IProduct } from '../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ProductSidebar } from '../sidebar/sidebar';
import { PaymentOption } from '../widgets/payment-option/payment-option';
import { ProductAction } from '../widgets/product-action/product-action';
import { ProductBundle } from '../widgets/product-bundle/product-bundle';
import { ProductContain } from '../widgets/product-contain/product-contain';
import { ProductDeliveryInformation } from '../widgets/product-delivery-information/product-delivery-information';
import { ProductDetailsTabs } from '../widgets/product-details-tabs/product-details-tabs';
import { ProductInformation } from '../widgets/product-information/product-information';
import { ProductSocialShare } from '../widgets/product-social-share/product-social-share';
import { VideoPlayModal } from '../widgets/video-play-modal/video-play-modal';

@Component({
  selector: 'app-product-thumbnail',
  imports: [
    TranslateModule,
    CarouselModule,
    NgxImageZoomModule,
    ProductContain,
    ProductAction,
    ProductInformation,
    ProductDeliveryInformation,
    PaymentOption,
    ProductSocialShare,
    ProductBundle,
    ProductDetailsTabs,
    ProductSidebar,
  ],
  templateUrl: './product-thumbnail.html',
  styleUrl: './product-thumbnail.scss',
})
export class ProductThumbnail {
  @Input() product: IProduct;
  readonly option = input<IOption | null>();

  readonly VideoPlayModal = viewChild<VideoPlayModal>('videoPlayModal');

  public activeSlide: string = '0';
  public videType = ['video/mp4', 'video/webm', 'video/ogg'];
  public audioType = ['audio/mpeg', 'audio/wav', 'audio/ogg'];

  public productMainThumbSlider = data.productMainThumbSlider;
  public productThumbSlider = data.productThumbSlider;
}
