import { CommonModule } from '@angular/common';
import { Component, inject, Input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../../../../environments/environment';
import { IProduct } from '../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';
import { ProductBanner } from '../widgets/product-banner/product-banner';
import { StoreInformation } from '../widgets/store-information/store-information';
import { TrendingProducts } from '../widgets/trending-products/trending-products';

@Component({
  selector: 'app-product-details-sidebar',
  imports: [CommonModule, StoreInformation, TrendingProducts, ProductBanner],
  templateUrl: './sidebar.html',
  styleUrl: './sidebar.scss',
})
export class ProductSidebar {
  themeOptions$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  @Input() product: IProduct;

  public storageURL = environment.storageURL;
}
