import { CommonModule } from '@angular/common';
import { Component, inject, Input, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { DeliveryReturnModal } from '../../../../../../shared/components/widgets/modal/delivery-return-modal/delivery-return-modal';
import { QuestionModal } from '../../../../../../shared/components/widgets/modal/question-modal/question-modal';
import { SizeChartModal } from '../../../../../../shared/components/widgets/modal/size-chart-modal/size-chart-modal';
import { IProduct } from '../../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../../shared/interface/theme-option.interface';
import { ThemeOptionState } from '../../../../../../shared/state/theme-option.state';

@Component({
  selector: 'app-product-action',
  imports: [TranslateModule, CommonModule, SizeChartModal, DeliveryReturnModal, QuestionModal],
  templateUrl: './product-action.html',
  styleUrl: './product-action.scss',
})
export class ProductAction {
  private store = inject(Store);

  @Input() product: IProduct;

  readonly SizeChartModal = viewChild<SizeChartModal>('sizeChartModal');
  readonly DeliveryReturnModal = viewChild<DeliveryReturnModal>('deliveryReturnModal');
  readonly QuestionModal = viewChild<QuestionModal>('questionModal');

  themeOptions$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public policy: string;
  public isLogin: boolean;

  constructor() {
    this.themeOptions$.subscribe(option => {
      this.policy = option?.product?.shipping_and_return;
    });
    this.isLogin = !!this.store.selectSnapshot(state => state.auth && state.auth.access_token);
  }
}
