import { Component, SimpleChanges, input } from '@angular/core';

import { ImageLink } from '../../../../../../shared/components/widgets/image-link/image-link';
import { ILink } from '../../../../../../shared/interface/theme.interface';

@Component({
  selector: 'app-product-banner',
  imports: [ImageLink],
  templateUrl: './product-banner.html',
  styleUrl: './product-banner.scss',
})
export class ProductBanner {
  readonly image = input<string>();

  public banner: ILink;

  ngOnChanges(change: SimpleChanges) {
    if (change['image']) {
      let img = change['image']?.currentValue;
      this.banner = {
        redirect_link: {
          link_type: 'collection',
          link: 'vegetables-fruits',
        },
        image_url: img,
      };
    }
  }
}
