import { CommonModule } from '@angular/common';
import { Component, inject, input, SimpleChanges } from '@angular/core';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetQuestionAnswersAction } from '../../../../../../shared/action/questions-answers.action';
import { GetReviewAction } from '../../../../../../shared/action/review.action';
import { IProduct } from '../../../../../../shared/interface/product.interface';
import { IQnAModel } from '../../../../../../shared/interface/questions-answers.interface';
import { IReviewModel } from '../../../../../../shared/interface/review.interface';
import { QuestionAnswersState } from '../../../../../../shared/state/questions-answers.state';
import { ReviewState } from '../../../../../../shared/state/review.state';
import { ProductReview } from '../product-review/product-review';
import { QuestionsAnswers } from '../questions-answers/questions-answers';

@Component({
  selector: 'app-product-details-accordion',
  imports: [TranslateModule, NgbModule, CommonModule, ProductReview, QuestionsAnswers],
  templateUrl: './product-details-accordion.html',
  styleUrl: './product-details-accordion.scss',
})
export class ProductDetailsAccordion {
  private store = inject(Store);

  readonly product = input<IProduct | null>();

  question$: Observable<IQnAModel> = inject(Store).select(QuestionAnswersState.questionsAnswers);
  review$: Observable<IReviewModel> = inject(Store).select(ReviewState.review);

  ngOnChanges(changes: SimpleChanges) {
    let product = changes['product']?.currentValue;
    this.store.dispatch(new GetQuestionAnswersAction({ product_id: product.id }));
    this.store.dispatch(new GetReviewAction({ product_id: product.id }));
  }
}
