import { CommonModule } from '@angular/common';
import { Component, Input, viewChild } from '@angular/core';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';

import { Button } from '../../../../../../shared/components/widgets/button/button';
import { ReviewModal } from '../../../../../../shared/components/widgets/modal/review-modal/review-modal';
import { NoData } from '../../../../../../shared/components/widgets/no-data/no-data';
import { IProduct } from '../../../../../../shared/interface/product.interface';
import { IReview } from '../../../../../../shared/interface/review.interface';

@Component({
  selector: 'app-product-review',
  imports: [CommonModule, TranslateModule, NgbModule, Button, NoData, ReviewModal],
  templateUrl: './product-review.html',
  styleUrl: './product-review.scss',
})
export class ProductReview {
  @Input() product: IProduct | null;
  @Input() reviews: IReview[] = [];

  readonly ProfileModal = viewChild<ReviewModal>('reviewModal');
}
