import { Component, Input, input } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';

import { environment } from '../../../../../../../environments/environment';
import { IProduct } from '../../../../../../shared/interface/product.interface';
import { IOption } from '../../../../../../shared/interface/theme-option.interface';

@Component({
  selector: 'app-product-social-share',
  imports: [TranslateModule],
  templateUrl: './product-social-share.html',
  styleUrl: './product-social-share.scss',
})
export class ProductSocialShare {
  @Input() product: IProduct;
  readonly option = input<IOption | null>();

  url: string = environment.baseURL;

  shareOnFacebook(slug: string) {
    const facebookShareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(this.url + '/product/' + slug)}`;
    window.open(facebookShareUrl, '_blank');
  }

  shareOnTwitter(slug: string) {
    const twitterShareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(this.url + '/product/' + slug)}`;
    window.open(twitterShareUrl, '_blank');
  }

  shareOnLinkedIn(slug: string) {
    const linkedInShareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(this.url + '/product/' + slug)}`;
    window.open(linkedInShareUrl, '_blank');
  }

  shareOnWhatsApp(slug: string) {
    const whatsappShareUrl = `https://api.whatsapp.com/send?text=${encodeURIComponent(this.url + '/product/' + slug)}`;
    window.open(whatsappShareUrl, '_blank');
  }

  shareViaEmail(slug: string) {
    const subject = 'Check out this awesome product!';
    const body = `I thought you might be interested in this product: ${this.url + '/product/' + slug}`;
    const emailShareUrl = `mailto:?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(body)}`;
    window.location.href = emailShareUrl; // Use location.href to open the default email client
  }
}
