import { Component, inject, TemplateRef, viewChild } from '@angular/core';

import { ModalDismissReasons, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { CarouselModule } from 'ngx-owl-carousel-o';

import * as data from '../../../../../../shared/data/owl-carousel';
import { IAttachment } from './../../../../../../shared/interface/attachment.interface';

@Component({
  selector: 'app-video-play-modal',
  imports: [CarouselModule],
  templateUrl: './video-play-modal.html',
  styleUrl: './video-play-modal.scss',
})
export class VideoPlayModal {
  private modalService = inject(NgbModal);

  readonly VideoPlayModal = viewChild<TemplateRef<string>>('videoPlayModal');

  public closeResult: string;
  public modalOpen: boolean = true;
  public video: IAttachment;
  public galleries: IAttachment[];
  public type: string;
  public singleSlider = data.singleSlider;
  public videType = ['video/mp4', 'video/webm', 'video/ogg'];
  public audioType = ['audio/mpeg', 'audio/wav', 'audio/ogg'];

  async openModal(video: any, type: string) {
    this.type = type;
    if (this.type === 'img') {
      this.galleries = video;
    } else {
      this.video = video;
    }
    this.modalOpen = true;
    this.modalService
      .open(this.VideoPlayModal(), {
        ariaLabelledBy: 'video-modal',
        centered: true,
        windowClass: 'theme-modal modal-lg exit-modal audio-video-modal',
      })
      .result.then(
        result => {
          `Result ${result}`;
        },
        reason => {
          this.closeResult = `Dismissed ${this.getDismissReason(reason)}`;
        },
      );
  }

  private getDismissReason(reason: ModalDismissReasons): string {
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }
}
