import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { TranslatePipe } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetProductsAction } from '../../../shared/action/product.action';
import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { Params } from '../../../shared/interface/core.interface';
import { IProductModel } from '../../../shared/interface/product.interface';
import { IPublication } from '../../../shared/interface/publication.interface';
import { ProductState } from '../../../shared/state/product.state';
import { PublicationState } from '../../../shared/state/publication.state';
import { CollectionProducts } from '../collection/widgets/collection-products/collection-products';

@Component({
  selector: 'app-publication',
  imports: [CommonModule, Breadcrumb, CollectionProducts, TranslatePipe],
  templateUrl: './publication.html',
  styleUrl: './publication.scss',
})
export class Publication {
  private route = inject(ActivatedRoute);
  private store = inject(Store);

  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);
  publication$: Observable<IPublication> = inject(Store).select(
    PublicationState.selectedPublication,
  ) as Observable<IPublication>;

  public breadcrumb: IBreadcrumb = {
    title: 'Category',
    items: [{ label: '', active: false }],
  };
  public activeAuthor: string | null;
  public publication: IPublication;
  public filter: Params = {
    page: 1, // Current page number
    paginate: 40, // Display per page
    status: 1,
    field: 'created_at',
    price: '',
    category: '',
    tag: '',
    sort: 'asc', // ASC, DSC
    sortBy: 'asc',
    rating: '',
    attribute: '',
  };

  constructor() {
    if (this.route.snapshot.paramMap.get('slug')) {
      this.activeAuthor = this.route.snapshot.paramMap.get('slug');
    }
  }

  ngOnInit() {
    this.publication$.subscribe(publication => (this.publication = publication));
    this.breadcrumb.title = `Author: ${this.publication?.publisher_name}`;
    this.breadcrumb.items[0].label = this.publication?.publisher_name;
    this.filter['publication_id'] = this.publication.id;
    this.store.dispatch(new GetProductsAction(this.filter));
  }
}
