import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../../../../environments/environment';
import { Params } from '../../../../../shared/interface/core.interface';
import { IStores } from '../../../../../shared/interface/store.interface';
import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';
import { CollectionProducts } from '../../../collection/widgets/collection-products/collection-products';
import { Sidebar } from '../../../collection/widgets/sidebar/sidebar';
import { SellerStoreDescription } from '../../widgets/seller-store-description/seller-store-description';
import { SellerStoreLogo } from '../../widgets/seller-store-logo/seller-store-logo';
import { SellerStoreName } from '../../widgets/seller-store-name/seller-store-name';
import { SellerStoreRating } from '../../widgets/seller-store-rating/seller-store-rating';
import { SellerStoreSocialLinks } from '../../widgets/seller-store-social-links/seller-store-social-links';

@Component({
  selector: 'app-seller-details-basic',
  imports: [
    CommonModule,
    Sidebar,
    SellerStoreLogo,
    SellerStoreName,
    SellerStoreRating,
    SellerStoreDescription,
    SellerStoreSocialLinks,
    CollectionProducts,
  ],
  templateUrl: './seller-details-basic.html',
  styleUrl: './seller-details-basic.scss',
})
export class SellerDetailsBasic {
  readonly filter = input<Params>();
  @Input() store: IStores;

  public storageURL = environment.storageURL;

  themeOptions$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;
}
