import { Component, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';

import { Params } from '../../../../../shared/interface/core.interface';
import { IStores } from '../../../../../shared/interface/store.interface';
import { CollectionProducts } from '../../../collection/widgets/collection-products/collection-products';
import { Sidebar } from '../../../collection/widgets/sidebar/sidebar';
import { SellerStoreDescription } from '../../widgets/seller-store-description/seller-store-description';
import { SellerStoreLogo } from '../../widgets/seller-store-logo/seller-store-logo';
import { SellerStoreName } from '../../widgets/seller-store-name/seller-store-name';
import { SellerStoreRating } from '../../widgets/seller-store-rating/seller-store-rating';
import { SellerStoreSocialLinks } from '../../widgets/seller-store-social-links/seller-store-social-links';

@Component({
  selector: 'app-seller-details-classic',
  imports: [
    TranslateModule,
    RouterModule,
    Sidebar,
    SellerStoreLogo,
    SellerStoreName,
    SellerStoreRating,
    SellerStoreDescription,
    SellerStoreSocialLinks,
    CollectionProducts,
  ],
  templateUrl: './seller-details-classic.html',
  styleUrl: './seller-details-classic.scss',
})
export class SellerDetailsClassic {
  readonly filter = input<Params>();
  readonly store = input<IStores>();
}
