import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { SellerDetailsBasic } from './seller-details-basic/seller-details-basic';
import { SellerDetailsClassic } from './seller-details-classic/seller-details-classic';
import { GetProductsAction } from '../../../../shared/action/product.action';
import { Breadcrumb } from '../../../../shared/components/widgets/breadcrumb/breadcrumb';
import { IBreadcrumb } from '../../../../shared/interface/breadcrumb';
import { Params } from '../../../../shared/interface/core.interface';
import { IProductModel } from '../../../../shared/interface/product.interface';
import { IStores } from '../../../../shared/interface/store.interface';
import { IOption } from '../../../../shared/interface/theme-option.interface';
import { ProductState } from '../../../../shared/state/product.state';
import { StoreState } from '../../../../shared/state/store.state';
import { ThemeOptionState } from '../../../../shared/state/theme-option.state';

@Component({
  selector: 'app-seller-details',
  imports: [CommonModule, Breadcrumb, SellerDetailsBasic, SellerDetailsClassic],
  templateUrl: './seller-details.html',
  styleUrl: './seller-details.scss',
})
export class SellerDetails {
  private route = inject(ActivatedRoute);
  private store = inject(Store);

  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);
  themeOptions$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;
  store$: Observable<IStores> = inject(Store).select(
    StoreState.selectedStore,
  ) as Observable<IStores>;

  public breadcrumb: IBreadcrumb = {
    title: 'Seller',
    items: [],
  };
  public layout: string = 'basic_store_details';
  public skeleton: boolean = true;

  public filter: Params = {
    page: 1, // Current page number
    paginate: 40, // Display per page,
    status: 1,
    field: 'price',
    price: '',
    category: '',
    tag: '',
    sort: '', // ASC, DSC
    sortBy: '',
    rating: '',
    attribute: '',
  };

  public totalItems: number = 0;

  constructor() {
    // Get Query params..
    this.route.queryParams.subscribe(params => {
      this.filter = {
        page: params['page'] ? params['page'] : 1,
        paginate: 40,
        status: 1,
        field: params['field'] ? params['field'] : '',
        price: params['price'] ? params['price'] : '',
        category: params['category'] ? params['category'] : '',
        tag: params['tag'] ? params['tag'] : '',
        sort: params['sort'] ? params['sort'] : '',
        sortBy: params['sortBy'] ? params['sortBy'] : '',
        rating: params['rating'] ? params['rating'] : '',
        attribute: params['attribute'] ? params['attribute'] : '',
      };

      this.route.params.subscribe(param => (this.filter['store_slug'] = param['slug']));

      this.breadcrumb.items = [];
      this.breadcrumb.title = this.filter['store_slug'] ? this.filter['store_slug'] : 'Seller';
      this.breadcrumb.items.push(
        { label: 'Seller Store', active: true },
        { label: this.breadcrumb.title, active: false },
      );

      this.store.dispatch(new GetProductsAction(this.filter));

      // Params For Demo Purpose only
      if (params['layout']) {
        this.layout = params['layout'];
      } else {
        // Get Layout
        this.themeOptions$.subscribe(_option => {
          this.layout = 'basic_store_details';
        });
      }

      this.filter['layout'] = this.layout;
    });

    this.product$.subscribe(product => (this.totalItems = product?.total));
  }
}
