import { Component, inject, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';

import { NoData } from '../../../../../shared/components/widgets/no-data/no-data';
import { IStores } from '../../../../../shared/interface/store.interface';
import { StoreService } from '../../../../../shared/services/store.service';
import { SellerContactDetails } from '../../widgets/seller-contact-details/seller-contact-details';
import { SellerStoreLogo } from '../../widgets/seller-store-logo/seller-store-logo';
import { SellerStoreName } from '../../widgets/seller-store-name/seller-store-name';
import { SellerStoreProductCounts } from '../../widgets/seller-store-product-counts/seller-store-product-counts';
import { SellerStoreProducts } from '../../widgets/seller-store-products/seller-store-products';
import { SellerStoreRating } from '../../widgets/seller-store-rating/seller-store-rating';
import { SkeletonSellerStore } from '../skeleton-seller-store/skeleton-seller-store';

@Component({
  selector: 'app-seller-store-basic',
  imports: [
    TranslateModule,
    RouterModule,
    SkeletonSellerStore,
    SellerStoreLogo,
    SellerStoreRating,
    SellerStoreName,
    SellerStoreProductCounts,
    SellerContactDetails,
    SellerStoreProducts,
    NoData,
  ],
  templateUrl: './seller-store-basic.html',
  styleUrl: './seller-store-basic.scss',
})
export class SellerStoreBasic {
  public storeService = inject(StoreService);

  readonly stores = input<IStores[]>();
  readonly skeletonItems = input<number[]>();
}
