import { Component, inject, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';

import { NoData } from '../../../../../shared/components/widgets/no-data/no-data';
import { IStores } from '../../../../../shared/interface/store.interface';
import { StoreService } from '../../../../../shared/services/store.service';
import { SellerContactDetails } from '../../widgets/seller-contact-details/seller-contact-details';
import { SellerStoreLogo } from '../../widgets/seller-store-logo/seller-store-logo';
import { SellerStoreName } from '../../widgets/seller-store-name/seller-store-name';
import { SellerStoreRating } from '../../widgets/seller-store-rating/seller-store-rating';
import { SkeletonSellerStore } from '../skeleton-seller-store/skeleton-seller-store';

@Component({
  selector: 'app-seller-store-classic',
  imports: [
    TranslateModule,
    RouterModule,
    SkeletonSellerStore,
    SellerContactDetails,
    SellerStoreName,
    SellerStoreRating,
    SellerStoreLogo,
    NoData,
  ],
  templateUrl: './seller-store-classic.html',
  styleUrl: './seller-store-classic.scss',
})
export class SellerStoreClassic {
  public storeService = inject(StoreService);

  readonly stores = input<IStores[]>();
  readonly skeletonItems = input<number[]>();
}
