import { Component, inject } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../../environments/environment';
import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { IOption } from '../../../shared/interface/theme-option.interface';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';

@Component({
  selector: 'app-seller',
  imports: [TranslateModule, Breadcrumb],
  templateUrl: './seller.html',
  styleUrl: './seller.scss',
})
export class Seller {
  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public breadcrumb: IBreadcrumb = {
    title: 'Become Seller',
    items: [{ label: 'Become Seller', active: true }],
  };
  public storageURL = environment.storageURL;
  public data?: IOption;

  constructor() {
    this.themeOption$.subscribe(data => (this.data = data));
  }
}
