import { Routes } from '@angular/router';

import { AuthGuard } from '../../core/guard/auth.guard';
import { CheckoutGuard } from '../../core/guard/checkout.guard';
import { AuthorResolver } from '../../shared/resolvers/author.resolver';
import { BrandResolver } from '../../shared/resolvers/brand.resolver';
import { CategoryResolver } from '../../shared/resolvers/category.resolver';
import { ProductResolver } from '../../shared/resolvers/product.resolver';
import { PublicationResolver } from '../../shared/resolvers/publication.resolver';
import { StoreResolver } from '../../shared/resolvers/store.resolver';

export const shopRoutes: Routes = [
  {
    path: 'cart',
    loadComponent: () => import('./cart/cart').then(m => m.Cart),
  },
  {
    path: 'wishlist',
    loadComponent: () => import('./wishlist/wishlist').then(m => m.Wishlist),
    canActivate: [AuthGuard],
  },
  {
    path: 'compare',
    loadComponent: () => import('./compare/compare').then(m => m.Compare),
    canActivate: [AuthGuard],
  },
  {
    path: 'product/:slug',
    loadComponent: () => import('./product/product').then(m => m.Product),
    resolve: {
      data: ProductResolver,
    },
  },
  {
    path: 'collections',
    loadComponent: () => import('./collection/collection').then(m => m.Collection),
  },
  {
    path: 'seller/become-seller',
    loadComponent: () => import('./seller/seller').then(m => m.Seller),
  },
  {
    path: 'seller/stores',
    loadComponent: () => import('./seller/seller-store/seller-store').then(m => m.SellerStore),
  },
  {
    path: 'seller/store/:slug',
    loadComponent: () =>
      import('./seller/seller-details/seller-details').then(m => m.SellerDetails),
    resolve: {
      data: StoreResolver,
    },
  },
  {
    path: 'checkout',
    loadComponent: () => import('./checkout/checkout').then(m => m.Checkout),
    canActivate: [CheckoutGuard],
  },
  {
    path: 'order/tracking',
    loadComponent: () => import('./order-tracking/order-tracking').then(m => m.OrderTracking),
  },
  {
    path: 'order/details',
    loadComponent: () => import('./order-details/order-details').then(m => m.OrderDetails),
  },
  {
    path: 'brand/:slug',
    loadComponent: () => import('./brand/brand').then(m => m.Brand),
    resolve: {
      data: BrandResolver,
    },
  },
  {
    path: 'category/:slug',
    loadComponent: () => import('./category/category').then(m => m.Category),
    resolve: {
      data: CategoryResolver,
    },
  },
  {
    path: 'author/:slug',
    loadComponent: () => import('./author/author').then(m => m.Author),
    resolve: {
      data: AuthorResolver,
    },
  },
  {
    path: 'publication/:slug',
    loadComponent: () => import('./publication/publication').then(m => m.Publication),
    resolve: {
      data: PublicationResolver,
    },
  },
];
