import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { ProductBox } from '../../../shared/components/widgets/product-box/product-box';
import { SkeletonProductBox } from '../../../shared/components/widgets/product-box/widgets/skeleton-product-box/skeleton-product-box';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { IOption } from '../../../shared/interface/theme-option.interface';
import { IWishlistModel } from '../../../shared/interface/wishlist.interface';
import { WishlistService } from '../../../shared/services/wishlist.service';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';
import { WishlistState } from '../../../shared/state/wishlist.state';
import { GetWishlistAction } from './../../../shared/action/wishlist.action';

@Component({
  selector: 'app-wishlist',
  imports: [CommonModule, Breadcrumb, SkeletonProductBox, ProductBox, NoData],
  templateUrl: './wishlist.html',
  styleUrl: './wishlist.scss',
})
export class Wishlist {
  private store = inject(Store);
  public wishlistService = inject(WishlistService);

  wishlistItems$: Observable<IWishlistModel> = inject(Store).select(WishlistState.wishlistItems);
  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public breadcrumb: IBreadcrumb = {
    title: 'Wishlist',
    items: [{ label: 'Wishlist', active: true }],
  };

  public skeletonItems = Array.from({ length: 12 }, (_, index) => index);

  constructor() {
    this.store.dispatch(new GetWishlistAction());
  }
}
