import { Component, inject, Input, input } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Store } from '@ngxs/store';
import { forkJoin, Observable } from 'rxjs';

import { GetBlogsAction } from '../../../shared/action/blog.action';
import { GetBrandsAction } from '../../../shared/action/brand.action';
import { GetProductByIdsAction } from '../../../shared/action/product.action';
import { GetStoresAction } from '../../../shared/action/store.action';
import { ImageLink } from '../../../shared/components/widgets/image-link/image-link';
import { Title } from '../../../shared/components/widgets/title/title';
import * as data from '../../../shared/data/owl-carousel';
import { IOption } from '../../../shared/interface/theme-option.interface';
import { IMadrid } from '../../../shared/interface/theme.interface';
import { ThemeOptionService } from '../../../shared/services/theme-option.service';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';
import { Banner } from '../widgets/banner/banner';
import { Blog } from '../widgets/blog/blog';
import { Brand } from '../widgets/brand/brand';
import { ThemeCategories } from '../widgets/categories/categories';
import { Deal } from '../widgets/deal/deal';
import { HomeBanner } from '../widgets/home-banner/home-banner';
import { Product } from '../widgets/product/product';
import { TopSeller } from '../widgets/top-seller/top-seller';
import { WalletOffer } from '../widgets/wallet-offer/wallet-offer';

@Component({
  selector: 'app-madrid',
  imports: [
    HomeBanner,
    Banner,
    Title,
    ThemeCategories,
    Product,
    WalletOffer,
    Deal,
    TopSeller,
    ImageLink,
    Blog,
    Brand,
  ],
  templateUrl: './madrid.html',
  styleUrl: './madrid.scss',
})
export class Madrid {
  private themeOptionService = inject(ThemeOptionService);
  private route = inject(ActivatedRoute);
  private store = inject(Store);

  @Input() data?: IMadrid;
  readonly slug = input<string>();

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public categorySlider = data.categorySlider9;
  public productSlider6Item = data.productSlider6Item;
  public productSlider6ItemMargin = data.productSlider6ItemMargin;
  public customOptionsItem4 = data.customOptionsItem4;
  public item = 2;
  public enableDeal: boolean = true;

  ngOnInit() {
    if (this.data?.slug == this.slug()) {
      const getProducts$ = this.store.dispatch(
        new GetProductByIdsAction({
          status: 1,
          paginate: this.data?.content?.products_ids.length,
          ids: this.data?.content?.products_ids?.join(','),
        }),
      );
      const getBrand$ = this.store.dispatch(
        new GetBrandsAction({
          status: 1,
          ids: this.data?.content?.brands?.brand_ids?.join(),
        }),
      );
      const getStore$ = this.store.dispatch(
        new GetStoresAction({
          status: 1,
          ids: this.data?.content?.seller?.store_ids?.join(),
        }),
      );
      const getBlogs$ = this.store.dispatch(
        new GetBlogsAction({
          status: 1,
          ids: this.data?.content?.featured_blogs?.blog_ids?.join(','),
        }),
      );

      // Skeleton Loader
      document.body.classList.add('skeleton-body');

      forkJoin([getProducts$, getBlogs$, getBrand$, getStore$]).subscribe({
        complete: () => {
          document.body.classList.remove('skeleton-body');
          this.themeOptionService.preloader = false;
        },
      });
    }

    this.route.queryParams.subscribe(_params => {
      if (this.route.snapshot.data['data'].theme_option.productBox === 'digital') {
        if (
          this.productSlider6ItemMargin &&
          this.productSlider6ItemMargin.responsive &&
          this.productSlider6ItemMargin.responsive['1180']
        ) {
          this.productSlider6ItemMargin = {
            ...this.productSlider6ItemMargin,
            items: 4,
            responsive: {
              ...this.productSlider6ItemMargin.responsive,
              1180: {
                items: 4,
              },
            },
          };
        }
        this.item = this.enableDeal ? 2 : 4;
      } else {
        if (
          this.productSlider6ItemMargin &&
          this.productSlider6ItemMargin.responsive &&
          this.productSlider6ItemMargin.responsive['1180']
        ) {
          this.productSlider6ItemMargin = {
            ...this.productSlider6ItemMargin,
            items: 6,
            responsive: {
              ...this.productSlider6ItemMargin.responsive,
              1180: {
                items: 6,
              },
            },
          };
        }
        this.item = this.enableDeal ? 4 : 6;
      }
    });
  }

  getDeals(value: Boolean) {
    this.enableDeal = Boolean(value);
  }
}
