import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Store } from '@ngxs/store';
import { forkJoin, Observable } from 'rxjs';

import { GetProductByIdsAction } from '../../../shared/action/product.action';
import { ImageLink } from '../../../shared/components/widgets/image-link/image-link';
import { Title } from '../../../shared/components/widgets/title/title';
import * as data from '../../../shared/data/owl-carousel';
import { IOption } from '../../../shared/interface/theme-option.interface';
import { IMoscow } from '../../../shared/interface/theme.interface';
import { ThemeOptionService } from '../../../shared/services/theme-option.service';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';
import { Banner } from '../widgets/banner/banner';
import { Brand } from '../widgets/brand/brand';
import { ThemeCategories } from '../widgets/categories/categories';
import { FourColumnProduct } from '../widgets/four-column-product/four-column-product';
import { HomeBanner } from '../widgets/home-banner/home-banner';
import { INewsletter } from '../widgets/newsletter/newsletter';
import { Product } from '../widgets/product/product';

@Component({
  selector: 'app-moscow',
  imports: [
    CommonModule,
    HomeBanner,
    ThemeCategories,
    Title,
    Product,
    Banner,
    FourColumnProduct,
    ImageLink,
    Brand,
    INewsletter,
  ],
  templateUrl: './moscow.html',
  styleUrl: './moscow.scss',
})
export class Moscow {
  private themeOptionService = inject(ThemeOptionService);
  private route = inject(ActivatedRoute);
  private store = inject(Store);

  @Input() data?: IMoscow;
  readonly slug = input<string>();

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public categorySlider = data.categorySlider9;
  public productSlider6Item = data.productSlider6Item;

  ngOnInit() {
    if (this.data?.slug == this.slug()) {
      // Get Products
      const getProducts$ = this.store.dispatch(
        new GetProductByIdsAction({
          status: 1,
          paginate: this.data?.content?.products_ids.length,
          ids: this.data?.content?.products_ids?.join(','),
        }),
      );

      // Skeleton Loader
      document.body.classList.add('skeleton-body');

      forkJoin([getProducts$]).subscribe({
        complete: () => {
          document.body.classList.remove('skeleton-body');
          this.themeOptionService.preloader = false;
        },
      });
    }

    this.route.queryParams.subscribe(_params => {
      if (this.route.snapshot.data['data'].theme_option.productBox === 'digital') {
        if (
          this.productSlider6Item &&
          this.productSlider6Item.responsive &&
          this.productSlider6Item.responsive['1065']
        ) {
          this.productSlider6Item = {
            ...this.productSlider6Item,
            items: 4,
            responsive: {
              ...this.productSlider6Item.responsive,
              1065: {
                items: 4,
              },
            },
          };
        }
      } else {
        if (
          this.productSlider6Item &&
          this.productSlider6Item.responsive &&
          this.productSlider6Item.responsive['1065']
        ) {
          this.productSlider6Item = {
            ...this.productSlider6Item,
            items: 6,
            responsive: {
              ...this.productSlider6Item.responsive,
              1065: {
                items: 6,
              },
            },
          };
        }
      }
    });
  }
}
