import { Routes } from '@angular/router';

import { HomeResolver } from '../../shared/resolvers/home.resolver';

export const themeRoutes: Routes = [
  {
    path: 'home',
    loadComponent: () => import('./themes').then(m => m.Themes),
  },
  {
    path: '',
    loadComponent: () => import('./themes').then(m => m.Themes),
    runGuardsAndResolvers: 'paramsOrQueryParamsChange',
    resolve: {
      data: HomeResolver,
    },
  },
];
