import { Component, inject } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { Berlin } from './berlin/berlin';
import { Cairo } from './cairo/cairo';
import { Denver } from './denver/denver';
import { Madrid } from './madrid/madrid';
import { Moscow } from './moscow/moscow';
import { Osaka } from './osaka/osaka';
import { Paris } from './paris/paris';
import { Rome } from './rome/rome';
import { Tokyo } from './tokyo/tokyo';
import { GetHomePageAction } from '../../shared/action/theme.action';
import { ThemeOptionService } from '../../shared/services/theme-option.service';
import { ThemeState } from '../../shared/state/theme.state';

@Component({
  selector: 'app-themes',
  imports: [Paris, Tokyo, Osaka, Rome, Madrid, Berlin, Denver, Cairo, Moscow],
  templateUrl: './themes.html',
  styleUrl: './themes.scss',
})
export class Themes {
  private themeOptionService = inject(ThemeOptionService);
  private route = inject(ActivatedRoute);
  private store = inject(Store);

  homePage$: Observable<object | null> = inject(Store).select(ThemeState.homePage) as Observable<
    object | null
  >;
  activeTheme$: Observable<string> = inject(Store).select(
    ThemeState.activeTheme,
  ) as Observable<string>;

  public theme: string;
  public homePage: any;

  constructor() {
    this.route.queryParams.subscribe(params => {
      this.themeOptionService.preloader = true;
      this.activeTheme$.subscribe(theme => {
        this.theme = params['theme'] ? params['theme'] : theme;
        if (this.theme) {
          this.store
            .dispatch(new GetHomePageAction(params['theme'] ? params['theme'] : theme))
            .subscribe((data: any) => {
              this.homePage = data.theme.homePage;
              this.themeOptionService.preloader = false;
            });
        }
      });
    });
  }

  ngOnDestroy() {
    document.body.classList.remove('home');
  }
}
