import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { CarouselModule, OwlOptions } from 'ngx-owl-carousel-o';
import { Observable } from 'rxjs';

import { NoData } from '../../../../shared/components/widgets/no-data/no-data';
import * as data from '../../../../shared/data/owl-carousel';
import { IBlog, IBlogModel } from '../../../../shared/interface/blog.interface';
import { BlogService } from '../../../../shared/services/blog.service';
import { BlogState } from '../../../../shared/state/blog.state';
import { SkeletonBlog } from '../../../blog/skeleton-blog/skeleton-blog';

@Component({
  selector: 'app-blog',
  imports: [CommonModule, TranslateModule, RouterModule, CarouselModule, NoData, SkeletonBlog],
  templateUrl: './blog.html',
  styleUrl: './blog.scss',
})
export class Blog {
  public blogService = inject(BlogService);

  blog$: Observable<IBlogModel> = inject(Store).select(BlogState.blog) as Observable<IBlogModel>;

  readonly blogIds = input<number[]>([]);
  @Input() sliderOption: OwlOptions;
  readonly description = input<boolean>();

  public blogs: IBlog[] = [];
  public skeletonItems = Array.from({ length: 5 }, (_, index) => index);
  public blogOption = data.customOptionsItem3;

  ngOnChanges() {
    if (Array.isArray(this.blogIds())) {
      this.blog$.subscribe(blogs => {
        this.blogs = blogs.data.filter(blog => this.blogIds()?.includes(blog?.id!));
      });
    }
  }
}
