import { Component, inject, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { NoData } from '../../../../shared/components/widgets/no-data/no-data';
import { IBrand, IBrandModel } from '../../../../shared/interface/brand.interface';
import { BrandState } from '../../../../shared/state/brand.state';

@Component({
  selector: 'app-brand',
  imports: [RouterModule, NoData],
  templateUrl: './brand.html',
  styleUrl: './brand.scss',
})
export class Brand {
  readonly brandIds = input<number[]>();

  public brands: IBrand[];

  brand$: Observable<IBrandModel> = inject(Store).select(
    BrandState.brand,
  ) as Observable<IBrandModel>;

  ngOnInit() {
    this.brand$.subscribe(brands => {
      this.brands = brands.data.filter(brand => this.brandIds()?.includes(brand.id));
    });
  }
}
