import { Component, input, output } from '@angular/core';

import { OwlOptions } from 'ngx-owl-carousel-o';

import { Categories } from '../../../../shared/components/widgets/categories/categories';

@Component({
  selector: 'app-theme-categories',
  imports: [Categories],
  templateUrl: './categories.html',
  styleUrl: './categories.scss',
})
export class ThemeCategories {
  readonly categoryIds = input<number[]>([]);
  readonly style = input<string>('vertical');
  readonly title = input<string>();
  readonly image = input<string>();
  readonly theme = input<string>();
  readonly sliderOption = input<OwlOptions>();
  readonly selectedCategoryId = input<number>();

  readonly selectedCategory = output<number>();

  selectCategory(id: number) {
    this.selectedCategory.emit(id);
  }
}
