import { Component, inject, Input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IProduct, IProductModel } from '../../../../shared/interface/product.interface';
import { ISliderProductsTokyo } from '../../../../shared/interface/theme.interface';
import { ProductState } from '../../../../shared/state/product.state';
import { Product } from '../product/product';

@Component({
  selector: 'app-four-column-product',
  imports: [Product],
  templateUrl: './four-column-product.html',
  styleUrl: './four-column-product.scss',
})
export class FourColumnProduct {
  @Input() data?: ISliderProductsTokyo;
  @Input() col: string;

  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);

  getProducts(ids: number[]) {
    if (Array.isArray(ids)) {
      let filteredProducts: IProduct[] = [];
      this.product$.subscribe(products => {
        filteredProducts = products.data.filter(product => ids?.includes(product?.id!));
      });
      return filteredProducts;
    }
    return;
  }
}
