import { CommonModule } from '@angular/common';
import { Component, inject, input } from '@angular/core';
import { FormControl, ReactiveFormsModule, Validators } from '@angular/forms';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';

import { environment } from '../../../../../environments/environment';
import { SubscriptionAction } from '../../../../shared/action/subscription.action';
import { Button } from '../../../../shared/components/widgets/button/button';
import { INewsLetter } from '../../../../shared/interface/theme.interface';

@Component({
  selector: 'app-newsletter',
  imports: [CommonModule, TranslateModule, ReactiveFormsModule, Button],
  templateUrl: './newsletter.html',
  styleUrl: './newsletter.scss',
})
export class INewsletter {
  private store = inject(Store);

  readonly data = input<INewsLetter | null>();
  readonly style = input<string>('basic');

  public email = new FormControl('', [Validators.email]);
  public isSubmit: boolean = false;
  public storageURL = environment.storageURL;

  submit() {
    this.isSubmit = true;
    if (this.email.valid) {
      this.store.dispatch(new SubscriptionAction({ email: this.email.value! }));
      this.email.reset();
      this.isSubmit = false;
    }
  }
}
