import { Component, inject, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { NoData } from '../../../../shared/components/widgets/no-data/no-data';
import { IStores, IStoresModel } from '../../../../shared/interface/store.interface';
import { StoreState } from '../../../../shared/state/store.state';

@Component({
  selector: 'app-top-seller',
  imports: [RouterModule, NgbModule, NoData],
  templateUrl: './top-seller.html',
  styleUrl: './top-seller.scss',
})
export class TopSeller {
  readonly sellerIds = input<number[]>();

  public sellers: IStores[];

  store$: Observable<IStoresModel> = inject(Store).select(
    StoreState.store,
  ) as Observable<IStoresModel>;

  ngOnInit() {
    this.store$.subscribe(stores => {
      if (this.sellerIds()?.length)
        this.sellers = stores.data.filter(seller => this.sellerIds()?.includes(seller.id));
    });
  }
}
