import { Component, input } from '@angular/core';
import { FormsModule } from '@angular/forms';

import { TranslateModule } from '@ngx-translate/core';
import { CarouselModule } from 'ngx-owl-carousel-o';

import { environment } from '../../../../../environments/environment';
import { Button } from '../../../../shared/components/widgets/button/button';
import * as data from '../../../../shared/data/owl-carousel';
import { IOffer } from '../../../../shared/interface/theme.interface';

@Component({
  selector: 'app-wallet-offer',
  imports: [TranslateModule, CarouselModule, FormsModule, Button],
  templateUrl: './wallet-offer.html',
  styleUrl: './wallet-offer.scss',
})
export class WalletOffer {
  readonly offers = input<IOffer[]>();

  public customOptionsItem3 = data.customOptionsItem3;
  public storageURL = environment.storageURL;

  constructor() {}

  copyFunction(txt: string) {
    void navigator.clipboard.writeText(txt);
  }
}
