import { inject, Injectable } from '@angular/core';
import { RouterStateSnapshot, UrlTree } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IsSelectedZoneAction } from '../../shared/action/zone.action';

@Injectable({
  providedIn: 'root',
})
export class ZoneGuard {
  private store = inject(Store);

  canActivate(
    _state: RouterStateSnapshot,
  ): Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree {
    // // Store the attempted URL for redirecting after login
    if (!this.store.selectSnapshot(state => state.zone && state.zone.isZoneSelected)) {
      //     return this.router.createUrlTree(['/']);
      this.store.dispatch(new IsSelectedZoneAction());
    }

    return true;
  }
}
