import { Component, Input, input } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';

import { IOption } from '../../../../shared/interface/theme-option.interface';
import { IFooter } from '../../../interface/theme.interface';
import { NoData } from '../../widgets/no-data/no-data';
import { FooterAbout } from '../widgets/about/about';
import { FooterCategories } from '../widgets/categories/categories';
import { FooterContact } from '../widgets/contact/contact';
import { FooterCopyright } from '../widgets/copyright/copyright';
import { FooterLinks } from '../widgets/links/links';
import { FooterLogo } from '../widgets/logo/logo';
import { FooterPaymentOptions } from '../widgets/payment-options/payment-options';
import { FooterSocialLinks } from '../widgets/social-links/social-links';

@Component({
  selector: 'app-basic-footer',
  imports: [
    TranslateModule,
    FooterLogo,
    FooterAbout,
    FooterCategories,
    FooterLinks,
    FooterContact,
    FooterCopyright,
    FooterPaymentOptions,
    FooterSocialLinks,
    NoData,
  ],
  templateUrl: './basic-footer.html',
  styleUrl: './basic-footer.scss',
})
export class BasicFooter {
  @Input() data: IOption | null;
  readonly footer = input<IFooter>();

  public active: { [key: string]: boolean } = {
    categories: false,
    useful_link: false,
  };

  toggle(value: string) {
    this.active[value] = !this.active[value];
  }
}
