import { CommonModule } from '@angular/common';
import { Component, inject, input } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { BasicFooter } from './basic-footer/basic-footer';
import { SubscribeFooter } from './subscribe-footer/subscribe-footer';
import { IOption } from '../../interface/theme-option.interface';
import { IFooter } from '../../interface/theme.interface';
import { ThemeOptionState } from '../../state/theme-option.state';

@Component({
  selector: 'app-footer',
  imports: [CommonModule, SubscribeFooter, BasicFooter],
  templateUrl: './footer.html',
  styleUrl: './footer.scss',
})
export class Footer {
  public route = inject(ActivatedRoute);
  public router = inject(Router);

  readonly footer = input<IFooter>();

  public style: string;
  public path: string;

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  constructor() {
    this.route.queryParams.subscribe(params => (this.path = params['theme']));
    this.setFooter();
    void this.router.events.forEach(event => {
      if (event instanceof NavigationEnd) {
        this.setFooter();
      }
    });
  }

  setFooter() {
    if (this.path!) {
      if (this.path == 'cairo') {
        this.style = 'footer_subscribe';
      } else if (
        this.path == 'paris' ||
        this.path == 'tokyo' ||
        this.path == 'rome' ||
        this.path == 'osaka'
      ) {
        this.style = 'basic_footer';
      } else if (
        this.path == 'madrid' ||
        this.path == 'berlin' ||
        this.path == 'denver' ||
        this.path == 'moscow'
      ) {
        this.style = 'classic_footer';
      }
    } else {
      this.themeOption$.subscribe(theme => {
        this.style = theme?.footer ? theme?.footer.footer_style : 'basic_footer';
      });
    }
  }
}
