import { Component, inject, Input, input } from '@angular/core';
import { FormControl, ReactiveFormsModule, Validators } from '@angular/forms';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';

import { environment } from '../../../../../environments/environment';
import { SubscriptionAction } from '../../../action/subscription.action';
import { IOption } from '../../../interface/theme-option.interface';
import { IFooter } from '../../../interface/theme.interface';
import { Button } from '../../widgets/button/button';
import { BasicFooter } from '../basic-footer/basic-footer';

@Component({
  selector: 'app-subscribe-footer',
  imports: [TranslateModule, ReactiveFormsModule, BasicFooter, Button],
  templateUrl: './subscribe-footer.html',
  styleUrl: './subscribe-footer.scss',
})
export class SubscribeFooter {
  private store = inject(Store);

  @Input() data: IOption | null;
  readonly footer = input<IFooter>();

  public email = new FormControl('', [Validators.required, Validators.email]);
  public storageURL = environment.storageURL;

  public active: { [key: string]: boolean } = {
    categories: false,
    useful_link: false,
  };

  getText(text: string): string {
    const words = text.split(' ');
    const firstTwoWords = words.slice(0, 2)?.join(' ');
    const remainingText = words.slice(2)?.join(' ');
    return `<h2>${firstTwoWords} <span>${remainingText}</span></h2>`;
  }

  toggle(value: string) {
    this.active[value] = !this.active[value];
  }

  submit() {
    if (this.email.valid) {
      this.store.dispatch(new SubscriptionAction({ email: this.email.value! }));
      this.email.reset();
    }
  }
}
