import { Component, inject, input, SimpleChanges } from '@angular/core';
import { RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ICategory, ICategoryModel } from '../../../../interface/category.interface';
import { CategoryState } from '../../../../state/category.state';

@Component({
  selector: 'app-footer-categories',
  imports: [RouterModule],
  templateUrl: './categories.html',
  styleUrl: './categories.scss',
})
export class FooterCategories {
  readonly data = input<IOption | null>();

  category$: Observable<ICategoryModel> = inject(Store).select(
    CategoryState.category,
  ) as Observable<ICategoryModel>;

  public categories: ICategory[];

  ngOnChanges(changes: SimpleChanges) {
    const ids = changes['data']?.currentValue?.footer?.footer_categories;
    if (Array.isArray(ids)) {
      this.category$.subscribe(categories => {
        if (Array.isArray(categories.data)) {
          this.categories = categories.data.filter(category => ids?.includes(category.id));
        }
      });
    }
  }
}
