import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { IFooter } from '../../../../../shared/interface/theme.interface';
import { IValues } from '../../../../interface/setting.interface';
import { SettingState } from '../../../../state/setting.state';

@Component({
  selector: 'app-footer-logo',
  imports: [CommonModule, RouterModule],
  templateUrl: './logo.html',
  styleUrl: './logo.scss',
})
export class FooterLogo {
  readonly data = input<IOption | null>();

  @Input() footer: IFooter;

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;
}
