import { Component, Input, HostListener, input } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';

import { IOption } from '../../../interface/theme-option.interface';
import { Button } from '../../widgets/button/button';
import { Menu } from '../../widgets/menu/menu';
import { Call } from '../widgets/call/call';
import { Cart } from '../widgets/cart/cart';
import { CategoriesBlock } from '../widgets/categories/categories';
import { Deal } from '../widgets/deal/deal';
import { Logo } from '../widgets/logo/logo';
import { MyAccount } from '../widgets/my-account/my-account';
import { NavbarMenuButton } from '../widgets/navbar-menu-button/navbar-menu-button';
import { Search } from '../widgets/search/search';
import { Topbar } from '../widgets/topbar/topbar';
import { Wishlist } from '../widgets/wishlist/wishlist';

@Component({
  selector: 'app-basic-header',
  imports: [
    TranslateModule,
    Topbar,
    NavbarMenuButton,
    Logo,
    Search,
    Call,
    Wishlist,
    Cart,
    MyAccount,
    CategoriesBlock,
    Button,
    Deal,
    Menu,
  ],
  templateUrl: './basic-header.html',
  styleUrl: './basic-header.scss',
})
export class BasicHeader {
  @Input() data: IOption | null;
  readonly logo = input<string | null>();
  readonly sticky = input<boolean | number>(); // Default false
  readonly class = input<string>();

  public stick: boolean = false;
  public active: boolean = false;

  // @HostListener Decorator
  @HostListener('window:scroll', [])
  onWindowScroll() {
    let number =
      window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
    if (number >= 150 && window.innerWidth > 400) {
      this.stick = true;
    } else {
      this.stick = false;
    }
  }

  toggle(val: boolean) {
    this.active = val;
  }
}
